using Microsoft.AspNetCore.Mvc;
using Microsoft.EntityFrameworkCore;
using GlampingParadise.Data;
using GlampingParadise.Models;

namespace GlampingParadise.Controllers
{
    public class HomeController : Controller
    {
        private readonly ApplicationDbContext _context;

        public HomeController(ApplicationDbContext context)
        {
            _context = context;
        }

        public async Task<IActionResult> Index()
        {
            var cabins = await _context.Cabins
                .Where(c => c.IsAvailable)
                .Take(3)
                .ToListAsync();

            var plans = await _context.Plans
                .Where(p => p.IsActive)
                .Take(3)
                .ToListAsync();

            ViewBag.Cabins = cabins;
            ViewBag.Plans = plans;

            return View();
        }

        public IActionResult About()
        {
            return View();
        }

        public IActionResult Contact()
        {
            return View();
        }

        public async Task<IActionResult> Cabins()
        {
            var cabins = await _context.Cabins
                .Where(c => c.IsAvailable)
                .OrderBy(c => c.Name)
                .ToListAsync();

            return View(cabins);
        }

        public async Task<IActionResult> Plans()
        {
            var plans = await _context.Plans
                .Where(p => p.IsActive)
                .OrderBy(p => p.Name)
                .ToListAsync();

            return View(plans);
        }

        public async Task<IActionResult> CabinDetails(int id)
        {
            var cabin = await _context.Cabins
                .FirstOrDefaultAsync(c => c.Id == id && c.IsAvailable);

            if (cabin == null)
            {
                return NotFound();
            }

            return View(cabin);
        }

        public async Task<IActionResult> PlanDetails(int id)
        {
            var plan = await _context.Plans
                .FirstOrDefaultAsync(p => p.Id == id && p.IsActive);

            if (plan == null)
            {
                return NotFound();
            }

            return View(plan);
        }

        [ResponseCache(Duration = 0, Location = ResponseCacheLocation.None, NoStore = true)]
        public IActionResult Error()
        {
            return View();
        }
    }
}