-- Script SQL para crear la base de datos del Glamping Paradise
-- Ejecutar en SQL Server Management Studio

-- Crear la base de datos
CREATE DATABASE GlampingParadiseDB;
GO

USE GlampingParadiseDB;
GO

-- Tabla de Roles de Identity
CREATE TABLE [dbo].[AspNetRoles] (
    [Id] nvarchar(450) NOT NULL,
    [Name] nvarchar(256) NULL,
    [NormalizedName] nvarchar(256) NULL,
    [ConcurrencyStamp] nvarchar(max) NULL,
    CONSTRAINT [PK_AspNetRoles] PRIMARY KEY ([Id])
);
GO

-- Tabla de Usuarios de Identity
CREATE TABLE [dbo].[AspNetUsers] (
    [Id] nvarchar(450) NOT NULL,
    [UserName] nvarchar(256) NULL,
    [NormalizedUserName] nvarchar(256) NULL,
    [Email] nvarchar(256) NULL,
    [NormalizedEmail] nvarchar(256) NULL,
    [EmailConfirmed] bit NOT NULL,
    [PasswordHash] nvarchar(max) NULL,
    [SecurityStamp] nvarchar(max) NULL,
    [ConcurrencyStamp] nvarchar(max) NULL,
    [PhoneNumber] nvarchar(max) NULL,
    [PhoneNumberConfirmed] bit NOT NULL,
    [TwoFactorEnabled] bit NOT NULL,
    [LockoutEnd] datetimeoffset(7) NULL,
    [LockoutEnabled] bit NOT NULL,
    [AccessFailedCount] int NOT NULL,
    [FullName] nvarchar(100) NOT NULL,
    [Address] nvarchar(200) NULL,
    [RegistrationDate] datetime2(7) NOT NULL,
    CONSTRAINT [PK_AspNetUsers] PRIMARY KEY ([Id])
);
GO

-- Tabla de Claims de Usuario
CREATE TABLE [dbo].[AspNetUserClaims] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [UserId] nvarchar(450) NOT NULL,
    [ClaimType] nvarchar(max) NULL,
    [ClaimValue] nvarchar(max) NULL,
    CONSTRAINT [PK_AspNetUserClaims] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_AspNetUserClaims_AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [AspNetUsers] ([Id]) ON DELETE CASCADE
);
GO

-- Tabla de Logins de Usuario
CREATE TABLE [dbo].[AspNetUserLogins] (
    [LoginProvider] nvarchar(450) NOT NULL,
    [ProviderKey] nvarchar(450) NOT NULL,
    [ProviderDisplayName] nvarchar(max) NULL,
    [UserId] nvarchar(450) NOT NULL,
    CONSTRAINT [PK_AspNetUserLogins] PRIMARY KEY ([LoginProvider], [ProviderKey]),
    CONSTRAINT [FK_AspNetUserLogins_AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [AspNetUsers] ([Id]) ON DELETE CASCADE
);
GO

-- Tabla de Roles de Usuario
CREATE TABLE [dbo].[AspNetUserRoles] (
    [UserId] nvarchar(450) NOT NULL,
    [RoleId] nvarchar(450) NOT NULL,
    CONSTRAINT [PK_AspNetUserRoles] PRIMARY KEY ([UserId], [RoleId]),
    CONSTRAINT [FK_AspNetUserRoles_AspNetRoles_RoleId] FOREIGN KEY ([RoleId]) REFERENCES [AspNetRoles] ([Id]) ON DELETE CASCADE,
    CONSTRAINT [FK_AspNetUserRoles_AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [AspNetUsers] ([Id]) ON DELETE CASCADE
);
GO

-- Tabla de Tokens de Usuario
CREATE TABLE [dbo].[AspNetUserTokens] (
    [UserId] nvarchar(450) NOT NULL,
    [LoginProvider] nvarchar(450) NOT NULL,
    [Name] nvarchar(450) NOT NULL,
    [Value] nvarchar(max) NULL,
    CONSTRAINT [PK_AspNetUserTokens] PRIMARY KEY ([UserId], [LoginProvider], [Name]),
    CONSTRAINT [FK_AspNetUserTokens_AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [AspNetUsers] ([Id]) ON DELETE CASCADE
);
GO

-- Tabla de Cabañas
CREATE TABLE [dbo].[Cabins] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(100) NOT NULL,
    [Description] nvarchar(500) NOT NULL,
    [Capacity] int NOT NULL,
    [PricePerNight] decimal(18,2) NOT NULL,
    [ImageUrl] nvarchar(200) NULL,
    [IsAvailable] bit NOT NULL,
    [Amenities] nvarchar(1000) NULL,
    [CreatedDate] datetime2(7) NOT NULL,
    CONSTRAINT [PK_Cabins] PRIMARY KEY ([Id])
);
GO

-- Tabla de Planes
CREATE TABLE [dbo].[Plans] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [Name] nvarchar(100) NOT NULL,
    [Description] nvarchar(1000) NOT NULL,
    [Price] decimal(18,2) NOT NULL,
    [Duration] int NOT NULL,
    [ImageUrl] nvarchar(200) NULL,
    [IsActive] bit NOT NULL,
    [IncludedActivities] nvarchar(1000) NULL,
    [CreatedDate] datetime2(7) NOT NULL,
    CONSTRAINT [PK_Plans] PRIMARY KEY ([Id])
);
GO

-- Tabla de Reservas
CREATE TABLE [dbo].[Reservations] (
    [Id] int IDENTITY(1,1) NOT NULL,
    [UserId] nvarchar(450) NOT NULL,
    [CabinId] int NOT NULL,
    [PlanId] int NULL,
    [CheckInDate] datetime2(7) NOT NULL,
    [CheckOutDate] datetime2(7) NOT NULL,
    [NumberOfGuests] int NOT NULL,
    [TotalPrice] decimal(18,2) NOT NULL,
    [Status] int NOT NULL,
    [Notes] nvarchar(500) NULL,
    [ReservationDate] datetime2(7) NOT NULL,
    [LastModified] datetime2(7) NOT NULL,
    CONSTRAINT [PK_Reservations] PRIMARY KEY ([Id]),
    CONSTRAINT [FK_Reservations_AspNetUsers_UserId] FOREIGN KEY ([UserId]) REFERENCES [AspNetUsers] ([Id]),
    CONSTRAINT [FK_Reservations_Cabins_CabinId] FOREIGN KEY ([CabinId]) REFERENCES [Cabins] ([Id]),
    CONSTRAINT [FK_Reservations_Plans_PlanId] FOREIGN KEY ([PlanId]) REFERENCES [Plans] ([Id])
);
GO

-- Crear índices
CREATE INDEX [IX_AspNetRoleClaims_RoleId] ON [AspNetRoleClaims] ([RoleId]);
CREATE UNIQUE INDEX [RoleNameIndex] ON [AspNetRoles] ([NormalizedName]) WHERE [NormalizedName] IS NOT NULL;
CREATE INDEX [IX_AspNetUserClaims_UserId] ON [AspNetUserClaims] ([UserId]);
CREATE INDEX [IX_AspNetUserLogins_UserId] ON [AspNetUserLogins] ([UserId]);
CREATE INDEX [IX_AspNetUserRoles_RoleId] ON [AspNetUserRoles] ([RoleId]);
CREATE INDEX [EmailIndex] ON [AspNetUsers] ([NormalizedEmail]);
CREATE UNIQUE INDEX [UserNameIndex] ON [AspNetUsers] ([NormalizedUserName]) WHERE [NormalizedUserName] IS NOT NULL;
CREATE INDEX [IX_Reservations_CabinId] ON [Reservations] ([CabinId]);
CREATE INDEX [IX_Reservations_PlanId] ON [Reservations] ([PlanId]);
CREATE INDEX [IX_Reservations_UserId] ON [Reservations] ([UserId]);
GO

-- Insertar roles por defecto
INSERT INTO [AspNetRoles] ([Id], [Name], [NormalizedName], [ConcurrencyStamp])
VALUES 
    ('1', 'Admin', 'ADMIN', NEWID()),
    ('2', 'Cliente', 'CLIENTE', NEWID());
GO

-- Insertar datos semilla para cabañas
INSERT INTO [Cabins] ([Name], [Description], [Capacity], [PricePerNight], [ImageUrl], [IsAvailable], [Amenities], [CreatedDate])
VALUES 
    ('Cabaña Romántica', 'Perfecta para parejas, con vista al lago y jacuzzi privado', 2, 150.00, '/images/cabin1.jpg', 1, 'Jacuzzi, Vista al lago, Chimenea, WiFi, Aire acondicionado', GETDATE()),
    ('Cabaña Familiar', 'Espaciosa cabaña para familias con área de juegos', 6, 250.00, '/images/cabin2.jpg', 1, 'Área de juegos, Cocina completa, 2 habitaciones, WiFi, Parrilla', GETDATE()),
    ('Cabaña Aventura', 'Para los amantes de la naturaleza y deportes extremos', 4, 200.00, '/images/cabin3.jpg', 1, 'Equipos de aventura, Senderos privados, Fogata, WiFi', GETDATE());
GO

-- Insertar datos semilla para planes
INSERT INTO [Plans] ([Name], [Description], [Price], [Duration], [ImageUrl], [IsActive], [IncludedActivities], [CreatedDate])
VALUES 
    ('Plan Romántico', 'Incluye cena romántica, spa de parejas y tour en bote', 300.00, 2, '/images/plan1.jpg', 1, 'Cena romántica, Spa de parejas, Tour en bote, Desayuno en la cabaña', GETDATE()),
    ('Plan Familiar', 'Actividades para toda la familia con entretenimiento para niños', 450.00, 3, '/images/plan2.jpg', 1, 'Actividades para niños, Senderismo familiar, Fogata nocturna, Todas las comidas', GETDATE()),
    ('Plan Aventura', 'Para los amantes de la adrenalina y deportes extremos', 500.00, 3, '/images/plan3.jpg', 1, 'Canopy, Rappel, Kayak, Senderismo extremo, Camping nocturno', GETDATE());
GO

PRINT 'Base de datos creada exitosamente con datos semilla';