using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace GlampingParadise.Models
{
    public class Cabin
    {
        [Key]
        public int Id { get; set; }

        [Required(ErrorMessage = "El nombre de la cabaña es obligatorio")]
        [StringLength(100, ErrorMessage = "El nombre no puede exceder 100 caracteres")]
        [Display(Name = "Nombre de la cabaña")]
        public string Name { get; set; } = string.Empty;

        [Required(ErrorMessage = "La descripción es obligatoria")]
        [StringLength(500, ErrorMessage = "La descripción no puede exceder 500 caracteres")]
        [Display(Name = "Descripción")]
        public string Description { get; set; } = string.Empty;

        [Required(ErrorMessage = "La capacidad es obligatoria")]
        [Range(1, 20, ErrorMessage = "La capacidad debe estar entre 1 y 20 personas")]
        [Display(Name = "Capacidad (personas)")]
        public int Capacity { get; set; }

        [Required(ErrorMessage = "El precio por noche es obligatorio")]
        [Range(0.01, 10000, ErrorMessage = "El precio debe ser mayor a 0")]
        [Column(TypeName = "decimal(18,2)")]
        [Display(Name = "Precio por noche")]
        public decimal PricePerNight { get; set; }

        [StringLength(200, ErrorMessage = "La URL de la imagen no puede exceder 200 caracteres")]
        [Display(Name = "URL de la imagen")]
        public string? ImageUrl { get; set; }

        [Display(Name = "Disponible")]
        public bool IsAvailable { get; set; } = true;

        [StringLength(1000, ErrorMessage = "Las amenidades no pueden exceder 1000 caracteres")]
        [Display(Name = "Amenidades")]
        public string? Amenities { get; set; }

        [Display(Name = "Fecha de creación")]
        public DateTime CreatedDate { get; set; } = DateTime.Now;

        // Relación con reservas
        public virtual ICollection<Reservation> Reservations { get; set; } = new List<Reservation>();
    }
}