﻿// Models/Reserva.cs
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace GlampingParadise.Models
{

    public enum EstadoReserva
    {
        Pendiente,
        Confirmada,
        Cancelada
    }

    public class Reserva
    {
        [Key]
        public int Id { get; set; }

        [Required(ErrorMessage = "El usuario es obligatorio")]
        public string UserId { get; set; } // FK al usuario (Identity)

        [Required(ErrorMessage = "La cabaña es obligatoria")]
        public int CabinId { get; set; } // FK al alojamiento (cabaña, glamping unit...)
        public int? PlanId { get; set; }

        [Required(ErrorMessage = "La fecha de entrada es obligatoria")]
        [DataType(DataType.Date)]
        public DateTime FechaInicio { get; set; }

        [Required(ErrorMessage = "La fecha de salida es obligatoria")]
        [DataType(DataType.Date)]
        public DateTime FechaFin { get; set; }

        [Range(1, 20, ErrorMessage = "Invitados debe estar entre 1 y 20")]
        public int Invitados { get; set; } = 1;

        [Column(TypeName = "decimal(10,2)")]
        public decimal PrecioTotal { get; set; }

        public DateTime FechaCreacion { get; set; } = DateTime.UtcNow;

        public EstadoReserva Estado { get; set; } = EstadoReserva.Pendiente;

        // Navegación opcional
        // public Alojamiento Alojamiento { get; set; }
        // public ApplicationUser Usuario { get; set; }
    }
}
