# Glamping Paradise - Plataforma Web Completa

## Descripción
Glamping Paradise es una plataforma web completa desarrollada en ASP.NET Core MVC para la gestión de reservas de un glamping. La aplicación incluye autenticación basada en roles, gestión de cabañas y planes, sistema de reservas y panel administrativo.

## Características Principales

### 🏠 **Gestión de Cabañas**
- Catálogo completo de cabañas con imágenes y descripciones
- Filtros por capacidad, precio y disponibilidad
- Detalles completos con comodidades incluidas
- Sistema de disponibilidad en tiempo real

### 📋 **Planes de Experiencia**
- Diferentes planes con actividades incluidas
- Filtros por duración, precio y estado
- Itinerarios detallados por plan
- Información de qué incluye y qué no incluye cada plan

### 👥 **Sistema de Usuarios**
- Registro e inicio de sesión seguro
- Roles diferenciados (Cliente y Administrador)
- Gestión de perfiles de usuario
- Cambio de contraseñas con validaciones

### 📅 **Sistema de Reservas**
- Creación de reservas con validaciones
- Cálculo automático de precios
- Edición y cancelación de reservas
- Estados de reserva (Pendiente, Confirmada, Cancelada, Completada)

### 🛠️ **Panel Administrativo**
- Gestión completa de cabañas y planes
- Visualización y gestión de todas las reservas
- Filtros avanzados para administradores
- Actualización de estados de reserva

### 🎨 **Interfaz de Usuario**
- Diseño responsive con Bootstrap 5
- Interfaz moderna y atractiva
- Animaciones y efectos visuales
- Experiencia de usuario optimizada

## Tecnologías Utilizadas

- **Backend**: ASP.NET Core 8.0 MVC
- **Base de Datos**: SQL Server con Entity Framework Core
- **Autenticación**: ASP.NET Core Identity
- **Frontend**: Bootstrap 5, jQuery, Font Awesome
- **Validaciones**: Data Annotations y validaciones del lado cliente
- **Arquitectura**: Patrón MVC con ViewModels

## Estructura del Proyecto

```
GlampingParadise/
├── Controllers/           # Controladores MVC
│   ├── AccountController.cs
│   ├── AdminController.cs
│   ├── HomeController.cs
│   └── ReservationsController.cs
├── Data/                 # Contexto de base de datos
│   └── ApplicationDbContext.cs
├── Database/             # Scripts de base de datos
│   └── CreateDatabase.sql
├── Models/               # Modelos de datos
│   ├── ApplicationUser.cs
│   ├── Cabin.cs
│   ├── Plan.cs
│   └── Reservation.cs
├── ViewModels/           # ViewModels para las vistas
│   └── AccountViewModels.cs
├── Views/                # Vistas Razor
│   ├── Account/
│   ├── Admin/
│   ├── Home/
│   ├── Reservations/
│   └── Shared/
├── wwwroot/              # Archivos estáticos
│   ├── css/
│   └── js/
└── Program.cs            # Configuración de la aplicación
```

## Requisitos del Sistema

### Software Necesario
1. **.NET 8.0 SDK** - [Descargar aquí](https://dotnet.microsoft.com/download/dotnet/8.0)
2. **SQL Server** (LocalDB, Express o completo) - [Descargar aquí](https://www.microsoft.com/sql-server/sql-server-downloads)
3. **Visual Studio 2022** o **Visual Studio Code** (opcional pero recomendado)

### Verificar Instalación de .NET
```bash
dotnet --version
```

## Instalación y Configuración

### 1. Clonar o Descargar el Proyecto
```bash
# Si tienes el proyecto en un repositorio
git clone [URL_DEL_REPOSITORIO]
cd GlampingParadise

# O simplemente navega a la carpeta del proyecto
cd "C:\Users\super\Desktop\Bolaños\GlampingParadise"
```

### 2. Instalar .NET 8.0 SDK
Si no tienes .NET instalado:
1. Ve a https://dotnet.microsoft.com/download/dotnet/8.0
2. Descarga e instala el SDK de .NET 8.0
3. Reinicia tu terminal/PowerShell
4. Verifica la instalación: `dotnet --version`

### 3. Configurar la Base de Datos

#### Opción A: Usar SQL Server LocalDB (Recomendado para desarrollo)
```bash
# Instalar herramientas de Entity Framework
dotnet tool install --global dotnet-ef

# Crear la base de datos
dotnet ef database update
```

#### Opción B: Usar SQL Server completo
1. Modifica la cadena de conexión en `appsettings.json`:
```json
{
  "ConnectionStrings": {
    "DefaultConnection": "Server=TU_SERVIDOR;Database=GlampingParadiseDB;Trusted_Connection=true;TrustServerCertificate=true;"
  }
}
```

#### Opción C: Ejecutar script SQL manualmente
1. Abre SQL Server Management Studio
2. Ejecuta el script `Database/CreateDatabase.sql`

### 4. Restaurar Dependencias
```bash
dotnet restore
```

### 5. Compilar el Proyecto
```bash
dotnet build
```

### 6. Ejecutar la Aplicación
```bash
dotnet run
```

La aplicación estará disponible en:
- **HTTPS**: https://localhost:7001
- **HTTP**: http://localhost:5000

## Usuarios de Prueba

### Administrador
- **Email**: admin@glampingparadise.com
- **Contraseña**: Admin123!

### Cliente Demo
- **Email**: cliente@example.com
- **Contraseña**: Cliente123!

## Funcionalidades por Rol

### 👤 **Cliente**
- Ver catálogo de cabañas y planes
- Crear, editar y cancelar reservas
- Gestionar perfil personal
- Ver historial de reservas

### 👨‍💼 **Administrador**
- Todas las funciones de cliente
- Gestionar cabañas (crear, editar, eliminar)
- Gestionar planes (crear, editar, eliminar)
- Ver y gestionar todas las reservas
- Cambiar estados de reservas
- Acceso al panel administrativo

## Estructura de la Base de Datos

### Tablas Principales
- **AspNetUsers**: Usuarios del sistema (extendido con ApplicationUser)
- **Cabins**: Información de las cabañas
- **Plans**: Planes de experiencia disponibles
- **Reservations**: Reservas realizadas por los usuarios

### Relaciones
- Un usuario puede tener múltiples reservas
- Una reserva pertenece a una cabaña y puede incluir un plan
- Las cabañas y planes tienen estados de disponibilidad

## Desarrollo y Personalización

### Agregar Nuevas Funcionalidades
1. Crear modelos en la carpeta `Models/`
2. Actualizar el contexto en `Data/ApplicationDbContext.cs`
3. Crear migraciones: `dotnet ef migrations add NombreMigracion`
4. Aplicar migraciones: `dotnet ef database update`
5. Crear controladores y vistas según sea necesario

### Personalizar Estilos
- Modifica `wwwroot/css/site.css` para cambiar la apariencia
- Los colores principales están definidos en variables CSS en `:root`

### Agregar Validaciones
- Usa Data Annotations en los modelos
- Implementa validaciones personalizadas en los controladores
- Agrega validaciones del lado cliente en JavaScript

## Solución de Problemas Comunes

### Error: "dotnet no se reconoce"
- Instala .NET 8.0 SDK desde el sitio oficial
- Reinicia tu terminal
- Verifica que esté en el PATH del sistema

### Error de Conexión a Base de Datos
- Verifica que SQL Server esté ejecutándose
- Comprueba la cadena de conexión en `appsettings.json`
- Asegúrate de que la base de datos existe

### Error de Migración
```bash
# Eliminar migraciones existentes
dotnet ef migrations remove

# Crear nueva migración
dotnet ef migrations add InitialCreate

# Aplicar migración
dotnet ef database update
```

### Problemas de Permisos
- Ejecuta Visual Studio o terminal como administrador
- Verifica permisos en la carpeta del proyecto

## Próximas Mejoras

- [ ] Sistema de notificaciones por email
- [ ] Integración con pasarelas de pago
- [ ] API REST para aplicaciones móviles
- [ ] Sistema de calificaciones y reseñas
- [ ] Galería de imágenes múltiples por cabaña
- [ ] Sistema de descuentos y promociones
- [ ] Reportes y estadísticas avanzadas
- [ ] Integración con calendarios externos

## Soporte

Para soporte técnico o preguntas sobre el proyecto:
- **Email**: soporte@glampingparadise.com
- **Teléfono**: +57 300 123 4567

## Licencia

Este proyecto está desarrollado para fines educativos y de demostración.

---

**¡Disfruta explorando Glamping Paradise!** 🏕️✨