# Script de instalación y ejecución para Glamping Paradise
# Ejecutar como: .\setup.ps1

Write-Host "=== Glamping Paradise - Script de Instalación ===" -ForegroundColor Green
Write-Host ""

# Verificar si .NET está instalado
Write-Host "Verificando instalación de .NET..." -ForegroundColor Yellow
try {
    $dotnetVersion = dotnet --version
    Write-Host "✓ .NET encontrado: $dotnetVersion" -ForegroundColor Green
} catch {
    Write-Host "✗ .NET no está instalado" -ForegroundColor Red
    Write-Host "Por favor, instala .NET 8.0 SDK desde: https://dotnet.microsoft.com/download/dotnet/8.0" -ForegroundColor Yellow
    Write-Host "Presiona cualquier tecla para continuar después de instalar .NET..."
    $null = $Host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown")
    exit 1
}

Write-Host ""

# Restaurar dependencias
Write-Host "Restaurando dependencias del proyecto..." -ForegroundColor Yellow
try {
    dotnet restore
    Write-Host "✓ Dependencias restauradas correctamente" -ForegroundColor Green
} catch {
    Write-Host "✗ Error al restaurar dependencias" -ForegroundColor Red
    exit 1
}

Write-Host ""

# Instalar herramientas de Entity Framework
Write-Host "Instalando herramientas de Entity Framework..." -ForegroundColor Yellow
try {
    dotnet tool install --global dotnet-ef --skip-existing
    Write-Host "✓ Herramientas de EF instaladas" -ForegroundColor Green
} catch {
    Write-Host "⚠ Las herramientas de EF ya están instaladas o hubo un error menor" -ForegroundColor Yellow
}

Write-Host ""

# Crear migraciones y base de datos
Write-Host "Configurando base de datos..." -ForegroundColor Yellow
try {
    # Verificar si ya existen migraciones
    if (Test-Path "Migrations") {
        Write-Host "Las migraciones ya existen, aplicando a la base de datos..." -ForegroundColor Yellow
        dotnet ef database update
    } else {
        Write-Host "Creando migraciones iniciales..." -ForegroundColor Yellow
        dotnet ef migrations add InitialCreate
        Write-Host "Aplicando migraciones a la base de datos..." -ForegroundColor Yellow
        dotnet ef database update
    }
    Write-Host "✓ Base de datos configurada correctamente" -ForegroundColor Green
} catch {
    Write-Host "⚠ Error al configurar la base de datos. Puedes ejecutar manualmente:" -ForegroundColor Yellow
    Write-Host "   dotnet ef migrations add InitialCreate" -ForegroundColor Cyan
    Write-Host "   dotnet ef database update" -ForegroundColor Cyan
}

Write-Host ""

# Compilar el proyecto
Write-Host "Compilando el proyecto..." -ForegroundColor Yellow
try {
    dotnet build
    Write-Host "✓ Proyecto compilado correctamente" -ForegroundColor Green
} catch {
    Write-Host "✗ Error al compilar el proyecto" -ForegroundColor Red
    exit 1
}

Write-Host ""
Write-Host "=== Instalación Completada ===" -ForegroundColor Green
Write-Host ""
Write-Host "Usuarios de prueba disponibles:" -ForegroundColor Cyan
Write-Host "  Administrador:" -ForegroundColor White
Write-Host "    Email: admin@glampingparadise.com" -ForegroundColor Gray
Write-Host "    Contraseña: Admin123!" -ForegroundColor Gray
Write-Host ""
Write-Host "  Cliente Demo:" -ForegroundColor White
Write-Host "    Email: cliente@example.com" -ForegroundColor Gray
Write-Host "    Contraseña: Cliente123!" -ForegroundColor Gray
Write-Host ""

# Preguntar si quiere ejecutar el proyecto
$runProject = Read-Host "¿Deseas ejecutar el proyecto ahora? (s/n)"
if ($runProject -eq "s" -or $runProject -eq "S" -or $runProject -eq "y" -or $runProject -eq "Y") {
    Write-Host ""
    Write-Host "Iniciando Glamping Paradise..." -ForegroundColor Green
    Write-Host "La aplicación estará disponible en:" -ForegroundColor Yellow
    Write-Host "  HTTPS: https://localhost:7001" -ForegroundColor Cyan
    Write-Host "  HTTP:  http://localhost:5000" -ForegroundColor Cyan
    Write-Host ""
    Write-Host "Presiona Ctrl+C para detener el servidor" -ForegroundColor Yellow
    Write-Host ""
    
    dotnet run
} else {
    Write-Host ""
    Write-Host "Para ejecutar el proyecto manualmente, usa:" -ForegroundColor Yellow
    Write-Host "  dotnet run" -ForegroundColor Cyan
    Write-Host ""
    Write-Host "La aplicación estará disponible en:" -ForegroundColor Yellow
    Write-Host "  HTTPS: https://localhost:7001" -ForegroundColor Cyan
    Write-Host "  HTTP:  http://localhost:5000" -ForegroundColor Cyan
}