using Microsoft.AspNetCore.Identity;
using System.ComponentModel.DataAnnotations;

namespace GlampingParadise.Models
{
    public class ApplicationUser : IdentityUser
    {
        [Required(ErrorMessage = "El nombre es obligatorio")]
        [StringLength(100, ErrorMessage = "El nombre no puede exceder 100 caracteres")]
        [Display(Name = "Nombre completo")]
        public string FullName { get; set; } = string.Empty;

        [StringLength(200, ErrorMessage = "La dirección no puede exceder 200 caracteres")]
        [Display(Name = "Dirección")]
        public string? Address { get; set; }

        [Display(Name = "Fecha de registro")]
        public DateTime RegistrationDate { get; set; } = DateTime.Now;

        // Relación con reservas
        public virtual ICollection<Reservation> Reservations { get; set; } = new List<Reservation>();
    }
}