using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace GlampingParadise.Models
{
    public class Plan
    {
        [Key]
        public int Id { get; set; }

        [Required(ErrorMessage = "El nombre del plan es obligatorio")]
        [StringLength(100, ErrorMessage = "El nombre no puede exceder 100 caracteres")]
        [Display(Name = "Nombre del plan")]
        public string Name { get; set; } = string.Empty;

        [Required(ErrorMessage = "La descripción es obligatoria")]
        [StringLength(1000, ErrorMessage = "La descripción no puede exceder 1000 caracteres")]
        [Display(Name = "Descripción")]
        public string Description { get; set; } = string.Empty;

        [Required(ErrorMessage = "El precio es obligatorio")]
        [Range(0.01, 10000, ErrorMessage = "El precio debe ser mayor a 0")]
        [Column(TypeName = "decimal(18,2)")]
        [Display(Name = "Precio")]
        public decimal Price { get; set; }

        [Required(ErrorMessage = "La duración es obligatoria")]
        [Range(1, 30, ErrorMessage = "La duración debe estar entre 1 y 30 días")]
        [Display(Name = "Duración (días)")]
        public int Duration { get; set; }

        [StringLength(200, ErrorMessage = "La URL de la imagen no puede exceder 200 caracteres")]
        [Display(Name = "URL de la imagen")]
        public string? ImageUrl { get; set; }

        [Display(Name = "Activo")]
        public bool IsActive { get; set; } = true;

        [StringLength(1000, ErrorMessage = "Las actividades incluidas no pueden exceder 1000 caracteres")]
        [Display(Name = "Actividades incluidas")]
        public string? IncludedActivities { get; set; }

        [Display(Name = "Fecha de creación")]
        public DateTime CreatedDate { get; set; } = DateTime.Now;

        // Relación con reservas
        public virtual ICollection<Reservation> Reservations { get; set; } = new List<Reservation>();
    }
}