﻿using System;
using System.Windows.Forms;
using MiConexionDLL;

namespace MiAppEscritorio
{
    public partial class LoginForm : Form
    {
        public LoginForm()
        {
            InitializeComponent();
        }

        private void btnIngresar_Click(object sender, EventArgs e)
        {
            string usuario = txtUsuario.Text.Trim();
            string contrasena = txtContrasena.Text.Trim();

            // Validaciones básicas
            if (string.IsNullOrEmpty(usuario))
            {
                MessageBox.Show("Ingrese el nombre de usuario.");
                return;
            }
            if (string.IsNullOrEmpty(contrasena))
            {
                MessageBox.Show("Ingrese la contraseña.");
                return;
            }

            try
            {
                UsuarioDAL usuarioDAL = new UsuarioDAL();
                if (usuarioDAL.ValidarUsuario(usuario, contrasena))
                {
                    MessageBox.Show("Bienvenido " + usuario);
                    this.Hide();
                    MainForm mainForm = new MainForm();
                    mainForm.Show();
                }
                else
                {
                    MessageBox.Show("Usuario o contraseña incorrectos.");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show("Error de conexión: " + ex.Message);
            }
        }
    }
}
