﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.IO;
using System.Xml;

namespace MiConexionDLL
{
    public class ConexionSQL
    {
        private string _connectionString;

        public ConexionSQL()
        {
            CargarConexion();
        }

        private void CargarConexion()
        {
            try
            {
                string configPath = Path.Combine(AppDomain.CurrentDomain.BaseDirectory, "Connection.config");

                if (!File.Exists(configPath))
                    throw new FileNotFoundException("No se encontró el archivo de configuración de conexión.");

                XmlDocument xmlDoc = new XmlDocument();
                xmlDoc.Load(configPath);

                XmlNode nodo = xmlDoc.SelectSingleNode("//connectionStrings/add[@name='MiConexionSQL']");

                if (nodo == null)
                    throw new Exception("No se encontró la cadena de conexión en el archivo de configuración.");

                _connectionString = nodo.Attributes["connectionString"].Value;
            }
            catch (Exception ex)
            {
                throw new Exception("Error al cargar la conexión: " + ex.Message);
            }
        }

        public SqlConnection ObtenerConexion()
        {
            return new SqlConnection(_connectionString);
        }
    }
}
